unit XmlSerializerSectionHandler;

interface

uses System.Configuration, System.Xml, System.Xml.Serialization, System.Xml.XPath;

type
  TXmlSerializerSectionHandler = class(System.Object, IConfigurationSectionHandler)
  private
    { Private Declarations }
  public
    constructor Create;
    function &Create(Parent : System.Object; configContext : System.Object; Section : System.Xml.XmlNode) : System.Object;
  end;

implementation

{ TXmlSerializerSectionHandler }

function TXmlSerializerSectionHandler.&Create(Parent : System.Object; configContext : System.Object; Section : System.Xml.XmlNode) : System.Object;
var
  nav : XPathNavigator;
  typename : System.string;
  t: &Type;
  ser : XmlSerializer;
begin
  nav := Section.CreateNavigator;
  typename := System.String(nav.Evaluate('string(@type)'));
  t := System.Type.GetType(typename);
  ser := XmlSerializer.Create(t, XmlRootAttribute.Create(section.Name));

  Result := ser.Deserialize (XmlNodeReader.Create(section));
end;

constructor TXmlSerializerSectionHandler.Create;
begin
  inherited Create;
end;

end.
